//////////////////////////////////////////////////////////////////////
//																	//
// PROGRAM: SZABLON1 - WZR APLIKACJI ZGODNEJ Z WIN32				//
//																	//
//////////////////////////////////////////////////////////////////////

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#define STRICT	// danie cisego przestrzegania
				// zgodnoci typw w programie
#include <windows.h>	// plik nagwkowy funkcji API
						// Windows
#include <process.h>
#include <stdlib.h>
#include <winsock2.h>
#pragma comment(lib,"ws2_32.lib") //Winsock Library
 
#define BUFLEN 512  //Max length of buffer
#define PORT 8888   //The port on which to listen for incoming data
//#include <stdio.h>
#include "resource.h"

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
						// Prototyp gwnej funkcji
						// obsugi gwnego okna programu

void Server_Thread1(void* pvoid);
						// Prototyp funkcji wykonywanej wewntrz wtku.

HWND global_hwnd;
char global_buf[BUFLEN]="Bazowy tekst";
HANDLE  hMutex;                   // Mutual Exclusion Mutex


// Gwna funkcja programu:
int WINAPI WinMain(	HINSTANCE hInstance,	// uchwyt instancji 
											// programu
					HINSTANCE hPrevInstance,// 0
					PSTR szCmdLine,			// linia komend
					int iCmdShow)			// pocztkowy stan 
											// programu
{
	static char szAppName[]="Win1";
	HWND hwnd;			// uchwyt gwnego okna
	MSG  msg;			// struktura przechowujca messages
	WNDCLASS wndclass;	// struktura do konstruowania klasy okna

	hMutex = CreateMutex( NULL, FALSE, NULL );  // Cleared 

	// Tworzenie klasy gwnego okna:
	wndclass.style=CS_HREDRAW|CS_VREDRAW; // styl klasy okna
	wndclass.lpfnWndProc=WndProc;		  // nazwa gwnej procedury 
										  // sterujcej okna	
	wndclass.cbClsExtra=0;				  // dodatkowy obszar pamici
	wndclass.cbWndExtra=0;				  // dodatkowy obszar pamici
	wndclass.hInstance=hInstance;		  // instancja programu
	wndclass.hIcon=LoadIcon(NULL,IDI_APPLICATION); // ikona klasy okien
	wndclass.hCursor=LoadCursor(NULL,IDC_ARROW);   // ksztat kursora
	wndclass.hbrBackground=(HBRUSH)GetStockObject(WHITE_BRUSH);
													// kolor ta
	wndclass.lpszMenuName=MAKEINTRESOURCE(IDR_MENU1); // przyczone MENU
	wndclass.lpszClassName=szAppName;				  // indywidualna nazwa
													  // klasy okna

	RegisterClass(&wndclass); // zarejestrowanie klasy
	
	hwnd=CreateWindow(
						szAppName, // Nazwa klasy okna
						"Szablon1",// Napis w  pasku tytuu
						WS_OVERLAPPEDWINDOW, // Styl okna
						CW_USEDEFAULT, // pooenie okna x
						CW_USEDEFAULT, // pooenie okna y
						CW_USEDEFAULT, // wysoko okna
						CW_USEDEFAULT, // szeroko okna
						NULL,          // uchwyt do okna rodzica
						NULL,		   // uchwyt do menu lub identy-
									   // fikator okna dziecka	
						hInstance,	   // uchwyt do instancji programu
						NULL		   // uchwyt do danych tworzcych okno
					 );
	ShowWindow(hwnd,iCmdShow);  // przygotuj okno do wywietlenia
	UpdateWindow(hwnd);			// wylij pierwszy komunikat WM_PAINT
	global_hwnd = hwnd;
	//////////////////////////////////////////////////////////////////////
	// Obsuga ptli komunikatw :										//
	//////////////////////////////////////////////////////////////////////
	while(GetMessage(&msg,NULL,0,0))									
	{																	
		TranslateMessage(&msg);											
		DispatchMessage(&msg);											
	}																	
	return msg.wParam;												
}		


// Gwna procedura obsugi komunikatw okna:
LRESULT CALLBACK WndProc(HWND hwnd,
						 UINT iMsg,
						 WPARAM wParam,
						 LPARAM lParam)
{
	HDC HDCPaint;            // uchwyt obszaru kontekstu  
							 // urzdzenia klienta
	PAINTSTRUCT PaintStruct; // informacja o malowaniu
	RECT rect;				 // wsprzdne obszaru prostoktnego 
	
	switch(iMsg)
	{
		case WM_CREATE:
			SetTimer(hwnd,101,2000,NULL);
			_beginthread( Server_Thread1, 0, NULL );
			return 0;
		case WM_TIMER:
			InvalidateRect(hwnd,NULL,TRUE);
			return 0;
		case WM_COMMAND: // Komunikat przychodzcy po wybraniu 
						 // opcji menu itp
			switch(LOWORD(wParam))
			{
				// Wybrano opcj menu Plik->Koniec:
				case ID_PLIK_KONIEC:
					DestroyWindow(hwnd);
					return 0;
			}
			return 0;

		case WM_DESTROY: // Komunikat przychodzcy gdy okno 
						 // ma by zniszczone

			CloseHandle( hMutex );
			KillTimer(hwnd,101);
			PostQuitMessage(0);
			return 0;

		case WM_PAINT:  // Komunikat przychodzi w przypadku koniecznoci
						// "odmalowania" lub namalowania okna
			// Wyma okno, uzyskaj kontekst urzdzenia:
			HDCPaint=BeginPaint(hwnd,&PaintStruct);
			// Pobierz rozmiary obszaru roboczego okna
			GetClientRect(hwnd,&rect);
			// Wypisz tekst:
			WaitForSingleObject( hMutex, INFINITE );
				DrawText(HDCPaint,global_buf,-1,&rect,DT_SINGLELINE);
			ReleaseMutex( hMutex );
			// Zakocz rysowanie
 			EndPaint(hwnd, &PaintStruct);
			return 0;
		default:
			return DefWindowProc(hwnd,iMsg,wParam,lParam);
	
	}
}

void Server_Thread1(void* pvoid)
{	SOCKET s;
    struct sockaddr_in server, si_other;
    int slen , recv_len;
    char buf[BUFLEN];
    WSADATA wsa;
 
    slen = sizeof(si_other) ;
     
    //Initialise winsock
    //printf("\nInitialising Winsock...");
    if (WSAStartup(MAKEWORD(2,2),&wsa) != 0)
    {
        //printf("Failed. Error Code : %d",WSAGetLastError());
		MessageBox(	global_hwnd,
					"WSAStartup failure", 
					"Sample Multithread Server1", 
					MB_ICONEXCLAMATION | MB_OK); 
        exit(EXIT_FAILURE);
    }
    //printf("Initialised.\n");
     
    //Create a socket
    if((s = socket(AF_INET , SOCK_DGRAM , 0 )) == INVALID_SOCKET)
    {
        //printf("Could not create socket : %d" , WSAGetLastError());
		MessageBox(	global_hwnd,
					"Could Not Create Socket", 
					"Sample Multithread Server1", 
					MB_ICONEXCLAMATION | MB_OK); 

    }
    //printf("Socket created.\n");
     
    //Prepare the sockaddr_in structure
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons( PORT );
     
    //Bind
    if( bind(s ,(struct sockaddr *)&server , sizeof(server)) == SOCKET_ERROR)
    {
        //printf("Bind failed with error code : %d" , WSAGetLastError());
        MessageBox(	global_hwnd,
					"Bind failed", 
					"Sample Multithread Server1", 
					MB_ICONEXCLAMATION | MB_OK); 
		exit(EXIT_FAILURE);
    }
    //puts("Bind done");
 
    //keep listening for data
    while(1)
    {
        //printf("Waiting for data...");
        //fflush(stdout);
         
        //clear the buffer by filling null, it might have previously received data
        memset(buf,'\0', BUFLEN);
         
        //try to receive some data, this is a blocking call
        if ((recv_len = recvfrom(s, buf, BUFLEN, 0, (struct sockaddr *) &si_other, &slen)) == SOCKET_ERROR)
        {
            //printf("recvfrom() failed with error code : %d" , WSAGetLastError());
            MessageBox(	global_hwnd,
						"recvfrom() failed", 
						"Sample Multithread Server1", 
						MB_ICONEXCLAMATION | MB_OK); 
			exit(EXIT_FAILURE);
        }
         
		 WaitForSingleObject( hMutex, INFINITE );
			strcpy(global_buf,buf);
		 ReleaseMutex( hMutex );

        //print details of the client/peer and the data received
        //printf("Received packet from %s:%d\n", inet_ntoa(si_other.sin_addr), ntohs(si_other.sin_port));
        //printf("Data: %s\n" , buf);
         
        //now reply the client with the same data
        //if (sendto(s, buf, recv_len, 0, (struct sockaddr*) &si_other, slen) == SOCKET_ERROR)
        //{
        //    printf("sendto() failed with error code : %d" , WSAGetLastError());
        //    exit(EXIT_FAILURE);
        //}
    }
 
    closesocket(s);
    WSACleanup();
	_endthread();
}