# -*- coding: utf-8 -*-
"""
Created on Tue Apr 26 12:36:57 2016

@author: kswider
"""
   
# Podobnie jak wiele innych językow programowania, Python umożliwia definiowanie
# klas,ktore obejmują dane oraz funkcje operujące na tych danych. Czasami
# zachodzi potrzeba ich użycia celem zwiększenia przejrzystości i uproszczenia
# kodu.Być może najprościej jest objaśnić ich działanie przedstawiając dobrze
# skomentowany przykład.
# Założmy na chwilę, że w Pythonie nie wbudowano możliwości pracy ze zbiorami.
# W takim przypadku byłoby prawdopodobne, że chcielibyśmy utworzyć własną klasę
# Set.
# Jak ma zachowywać się tworzona przez nas klasa. Mając pewne wystąpienie klasy
# będziemy chcieli mieć możliwość dodawania do niego elementow, usuwania
# elementow oraz sprawdzania czy zawiera ono określoną wartość.Osiągniemy to
# wszystko stosując tzw. funkcje składowe klasy (metody), ktore będzie można
# uruchomić podając nazwę obiektu klasy Set oraz nazwę metody oddzielone kropką.
   
   # przyjmujemy, że fukcjom będą nadawane nazwy w konwencji Pascala
   class Set:
       
       # tutaj zostaną zdefiniowane metody
       # w każdej z nich pierwszym parametrem jest "self" (kolejna konwencja)
       # ktory odwołuje się do konkretnego obiektu klasy Set będącego w użyciu.
       
       def __init__(self, values=None):
           """ Jest to konstruktor.
           Jest on wywoływany wtedy, kiedy tworzymy nowy obiekt klasy Set.
           Użycie może wyglądać następująco:
           s1 = Set()           # pusty zbior
           s2 = Set([1,2,2,3])  # nadanie wartości początkowych"""
           
           self.dict = {}   # każde wystąpienie Set ma swoją właściwość dict
                            # ktora będzie użyta do sledzenia przynależności
           if values is not None:
               for value in values:
                   self.add(value)
                   
       def __repr__(self):
           """to jest przedstawienie obiektu Set za pomocą łańcucha
           po wpisanie w konsoli Pythona lub przekazaniu do str()"""
           return "Set: " + str(self.dict.keys())

       # przynależność będzie reprezentowana jako klucz w self.dict rowny True
       def add(self, value):
            self.dict[value] = True

       # wartość występuje w Set jeśli jest ona kluczem w słowniku
       def contains(self, value):
            return value in self.dict

       def remove(self, value):
            del self.dict[value]
            
# Użycie może wyglądać następująco
    s = Set([1,2,3])
    s.add(4)
    print s.contains(4) # True
    s.remove(3)
    print s.contains(3) # False
    s.__repr__()