# -*- coding: utf-8 -*-
"""
Created on Tue Apr 26 12:36:57 2016

@author: kswider
"""
   
# W pracy z danymi często zachodzi potrzeba generowania liczb losowych, co
# jest możliwe przy pomocy modułu random.
   
   import random
   four_uniform_randoms = [random.random() for _ in range(4)]
   
# random.random() dostarcza liczb losowych z przedziału od 0 do 1 o rozkładzie
# rownomiernym
   
# Moduł random w rzeczywistości wytwarza wartości pseudolosowe, tzn.
# deterministyczne uzyskane na podstawie stanu wewnętrznego. Wartość startową
# (ziarno pseudolosowe) można ustawic używając funkcji random.seed
# i w ten sposob uzyskać powtarzalne wyniki.
  
  random.seed(10)       # ustawia seed na 10
  print random.random() # 0.57140259469
  random.seed(10)       # ponownie ustawia seed na 10
  print random.random() # i znow 0.57140259469

# Można także użyć funkcji random.randrange, ktora może być wywołana z jednym
# lub dwoma argumentami i zwraca wartość losowo wybraną z odnosnego zakresu:

  random.randrange(10)   # wybiera losowo z range(10) = [0, 1, ..., 9]
  random.randrange(3, 6) # wybiera losowo z range(3, 6) = [3, 4, 5]
       
# Istnieje ponadto kilka innych przydatnych metod. Na przykład random.schufle
# losowo ustawia elementy listy.
      
  do_dziesieciu = range(10)
  random.shuffle(do_dziesieciu)
  print do_dziesieciu
  # [2, 5, 1, 9, 7, 3, 8, 6, 4, 0] (wynik jest losowy)
  
# Jesli potrzebujemy losowo wybrać jeden element z listy uzyjemy random.choice:
  
  najlepszy_kumpel = random.choice(["Alicja", "Janek", "Karol"]) 
  print najlepszy_kumpel             # Wybiera losowo
     
# Jeśli natomiast chcemy wybrać probke bez duplikatow możemy użyć
# random.sample
     
  liczby_loterii = range(60)
  liczby_wygrywajace = random.sample(liczby_loterii, 6)
  print liczby_wygrywajace
  # [16, 36, 10, 6, 25, 9]  wynik jest losowy

# Jeśli zezwalamy na duplikaty można po prostu wielokrotnie użyć random.choice

  cztery_ze_zwracaniem = [random.choice(range(10))
  for _ in range(4)]
  print cztery_ze_zwracaniem
  
  # [9, 4, 4, 2] wybiera losowo
 