# -*- coding: utf-8 -*-
"""
Created on Tue Apr 26 12:36:57 2016

@author: kswider
"""
   
# W przypadku list problemem jest to, że mogą one stosunkowo łatwo rozrastać
# się do znacznych rozmiarow, np. polecenie range(1000000) tworzy listę 
# składającą się z 1 miliona elementow. Jeśli chcemy użyć ich jednorazowo
# może to stać się źrodłem nieefektywności (łącznie z przepełnieniem pamięci).
# Jeśli potencjalnie będzie potrzebnych tylko kilka pierwszych wartości, to
# obliczanie wszystkich jest niepotrzebne.
   
# Generator jest czymś co może działać w pętli (np. for) przy czym wartości
# są wytwarzane z opoznieniem, tzn. dopiero wtedy, gdy są potrzebne.
# 
# Jednym ze sposobow utworzenia generatora jest uzycie funkcji i operatora
# yield:
   
   def range_z_opoznieniem(n):
       """wersja range z opoznieniem"""
       i = 0
       while i < n:
           yield i
           i += 1

# A tak wygląda pętla korzystająca z pojedynczych dostarczanych wartości
# aż do ich wyczerpania:

    for i in range_z_opoznieniem(10):
#        do_something_with(i)
        print i

# (W Pythonie rzeczywiście jest dostępna funkcja range z opoznieniem pod nazwą
# xrange a w Pythonie 3 sama range działa z opoznieniem). Można
# utworzyć nawet nieskończony ciąg:

    def liczby_naturalne():
        """zwraca 1, 2, 3, ..."""
        n = 1
        while True:
            yield n
            n += 1
            
# przy czym prawdopodobnie nie warto realizować takich iteracji bez
# zastosowania jakiegokolwiek warunku wyjścia z pętli.
# Efektem ubocznym generatorow jest to, że pętla generatora może być użyta
# tylko raz. Jesli zachodzi potrzeba wykonywania wielokrotnych iteracji, należy
# albo każdorazowo na nowo tworzyć generator, albo użyć listy.
            
# Innym sposobem tworzenia generatorow jest użycie generalizacji "for"
# umieszczonej w nawiasach:
        
    parzyste_z_opozn_poniz_20 = (i for i in 
        range_z_opoznieniem(20) if i % 2 == 0)
 
# Warto przypomnieć, że każdy obiekt słownikowy dict ma metodę items(), 
# ktora zwraca listę par "klucz-wartość". Częściej będzie używana metoda
# iteritems(), ktora w kolejnych iteracjach dostarcza z opoznieniem 
# pojedyncze pary klucz-wartość.
  

            
            
            