# -*- coding: utf-8 -*-
"""
Created on Tue Apr 26 12:36:57 2016

@author: kswider
"""
   
# Niekiedy zachodzi potrzeba przekształcenia pewnej listy na inną przez
# wybranie tylko niektorych jej elementow, transformację elementow, bądź
# zastosowanie obu tych operacji jednocześnie. Python udostępnia możliwość
# tzw. generalizacji list (list comprehensions), ktory pozwala na wykonać
# m.in.: następujące podstawienia:
   
   liczby_parzyste = [x for x in range(5) if x % 2 == 0]    # [0, 2, 4]
   kwadraty = [x * x for x in range(5)]                      # [0, 1, 4, 9, 16]
   kwadraty_parzystych = [x * x for x in liczby_parzyste]   # [0, 4, 16]
   
# W podobny sposob można zamienić listy na słowniki lub zbiory
   
   slownik_kwadratow = { x : x * x for x in range(5) }      # { 0:0, 1:1, 2:4, 
                                                            #   3:9, 4:16 }
   zbior_kwadratow = { x * x for x in [1, -1] }             # { 1 }
   
# Jeśli wartość elementu listy nie jest nam potrzebna, przyjęto, że jako 
# zmiennej używa się znaku podkreślenia.
   
   zera = [0 for _ in liczby_parzyste]  # ma tyle elementow co liczby_parzyste
   
# W generalizacji listy for może pojawić się wielokrotnie:
   
   pary = [(x, y)
           for x in range(2)
           for y in range(3)] # 6 par postaci: (0,0) (0,1) ... (1,1), (1,2)
          
# Pętle wewnętrzne mogą przy tym używać wynikow działania pętli zewnętrznych
          
   pary_narastajace = [(x, y) # tylko pary gdzie x < y,
                       for x in range(4) # range(lo, hi) equals
                       for y in range(x + 1, 4)] # [lo, lo + 1, ..., hi - 1]        