# -*- coding: utf-8 -*-
"""
Created on Tue Apr 26 12:36:57 2016

@author: kswider
"""
   
# Każda lista w Pythonie ma metodę sortującą, ktora wykonuje sortowanie
# w miejscu. Jeśli nie chcemy nic przestawiać w swojej liście, możemy
# użyć funkcji sortującej, ktora zwraca nową listę.
   
x = [4,1,2,3]
y = sorted(x)   # Podstawia [1,2,3,4], x pozostaje niezmienione
x.sort()        # Teraz x jest [1,2,3,4]

# Domyślnie sort (i sorted) sortują listy rosnąco. W przypadku, gdy chcemy
# to odwrocić, należy ustawić parametr reverse = True. Zamiast porownywać
# oryginalne wartości elementow listy można porownywać wartości wyznaczone
# dla tych elementow przez pewną funkcję wskazaną parametrem key.

# sortuj listę według malejących wartości bezwzględnych jej elementow
x = sorted([-4,1,-2,3], key=abs, reverse=True)

# sortuj słownik zawierający słowa i ich liczbę według malejącej liczby słow

liczniki_slow = {"ale":14, "i":2, "oraz":7}

wc = sorted(liczniki_slow.items(),
            key=lambda (slowo, liczba): liczba,
            reverse=True)
